﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/insertCoin.Master" CodeBehind="InsertCoin.aspx.cs" Inherits="Brian_LaRue.InsertCoin" %>

<asp:Content ID="Content2" ContentPlaceHolderID="head" runat="Server">
    <script type="text/javascript">
        function Validate() {
            // regex to check if numeric
            var reg = /^\d+$/;

            // check if name is not empty
            if (document.getElementById('TextBox1').value == '') {
                alert('Name cannot be empty');
                document.getElementById('TextBox1').focus();
                return false;
            }

            // check if weight is not empty
            if (document.getElementById('TextBox2').value == '') {
                alert('Weight cannot be empty');
                document.getElementById('TextBox2').focus();
                return false;
            }

            // check if weight is numeric
            if (!reg.test(document.getElementById('TextBox2').value)) {
                alert('Weight must be a numeric value');
                document.getElementById('TextBox2').focus();
                return false;
            }

            // check if weight is positive
            if (document.getElementById('TextBox2').value <= 0) {
                alert('Weight must be a positive value');
                document.getElementById('TextBox2').focus();
                return false;
            }

            // check if weight is in the range
            if (document.getElementById('TextBox2').value < 3 || document.getElementById('TextBox2').value > 8) {
                alert('Weight must be a in range of 3 to 8');
                document.getElementById('TextBox2').focus();
                return false;
            }

            // check if color is not empty
            if (document.getElementById('txtColor').value == '') {
                alert('Color cannot be empty');
                document.getElementById('txtColor').focus();
                return false;
            }

            // check if diameter is not empty
            if (document.getElementById('txtDiameter').value == '') {
                alert('Diameter cannot be empty');
                document.getElementById('txtDiameter').focus();
                return false;
            }

            // check if diameter is numeric
            if (!reg.test(document.getElementById('txtDiameter').value)) {
                alert('Diameter must be a numeric value');
                document.getElementById('txtDiameter').focus();
                return false;
            }

            // check if diameter is positive
            if (document.getElementById('txtDiameter').value <= 0) {
                alert('Diameter must be a positive value');
                document.getElementById('txtDiameter').focus();
                return false;
            }


            // check if thickness is not empty
            if (document.getElementById('txtThickness').value == '') {
                alert('Thickness cannot be empty');
                document.getElementById('txtThickness').focus();
                return false;
            }

            // check if thickness is numeric
            if (!reg.test(document.getElementById('txtThickness').value)) {
                alert('Thickness must be a numeric value');
                document.getElementById('txtThickness').focus();
                return false;
            }

            // check if thickness is positive
            if (document.getElementById('txtThickness').value <= 0) {
                alert('Thickness must be a positive value');
                document.getElementById('txtThickness').focus();
                return false;
            }

            // check if date is selected
            if ('<%= calendar.SelectedDate == DateTime.MinValue  %>' == "True") {
                alert('Select a Date');
                return false;
            }

            // check if date is valid
            if ('<%= calendar.SelectedDate.Date > DateTime.Now.Date  %>' == "True") {
                alert("Date cannot be greater than today's date");
                return false;
            }
            return true;
        }
    </script>
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="Main" runat="Server">
    <h2>Insert your coin details:</h2>
    <div>
        <asp:Label ID="Label1" runat="server" Text="Name: "></asp:Label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
        <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox>
        <br />
        <br />
        <asp:Label ID="Label2" runat="server" Text="Weight: "></asp:Label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <asp:TextBox ID="TextBox2" runat="server"></asp:TextBox>

        <br />
        <br />
        <asp:Label ID="lblColor" runat="server" Text="Color: "></asp:Label>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
            <asp:TextBox ID="txtColor" runat="server"></asp:TextBox>

        <br />
        <br />
        <asp:Label ID="lblDiameter" runat="server" Text="Diameter: "></asp:Label>&nbsp;
            <asp:TextBox ID="txtDiameter" runat="server"></asp:TextBox>

        <br />
        <br />
        <asp:Label ID="lblThickness" runat="server" Text="Thickness: "></asp:Label>
        <asp:TextBox ID="txtThickness" runat="server"></asp:TextBox>

        <br />
        <br />
        <asp:Label ID="lblDate" runat="server" Text="Date: "></asp:Label>
        <asp:Calendar ID="calendar" runat="server"></asp:Calendar>


        <br />
        <br />

        <asp:Button ID="Button1" runat="server" Text="Insert Coin" OnClick="myFunction" OnClientClick="return Validate();" />
        &nbsp;&nbsp;
            <asp:Button ID="btnCancel" runat="server" OnClick="btnCancel_Click" Text="Cancel" />
        <br />
        <br />
        <asp:Label ID="Label3" runat="server"></asp:Label>
        <br />
        <asp:Label ID="lblMessage" runat="server"></asp:Label>
        <br />
    </div>
</asp:Content>

